####################################################
### code chunk number : Simulations: Goodness-of-fit
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
alpha = 2            ## hyperparameter
beta = 1             ## hyperparameter
n = 8e3; n           ## sample size
m = 10               ## number of groups

set.seed(1) 
theta = rgamma(n = n, shape = alpha, rate = beta)
x = rpois(n = n, lambda = theta) ## the sample

## Histogram
hist(x, probability = FALSE, breaks = -1:max(x),
    main = paste("Histogram of" , "x"), 
    xlab = "x")

#### 
#### Goodness-of-fit
#### 

## Group and count
a = -1:9 ## cut-off points
a[m + 1] = Inf
a
nn = table(cut(x, br = a)); nn ## frequencies
sum(nn)

## 
## When alpha = 2 and beta = 1 are known.
## 
## Compute theoretical probabilities
p = rep(0, m)
for (i in 1:(m - 1)){
	p[i] = gamma(i - 1 + alpha) * beta^alpha / (gamma(i) * gamma(alpha) * (1 + beta)^(i - 1 + alpha))
}
p[m] = 1 - sum(p)
p
sum(p)

## Test
df_0 = Pearson_chisquare_test(nn = nn, p = p, r = 0); df_0

## 
## When alpha and beta are unknown, and they are estimated by their moment estimators.
## 

## Compute theoretical probabilities
## Moment estimators
alpha_1_beta_1 = Moment_estimators(x); alpha_1_beta_1
alpha_1 = alpha_1_beta_1[1]; alpha_1
beta_1 = alpha_1_beta_1[2]; beta_1
p_moment = rep(0, m)
for (i in 1:(m - 1)){
	p_moment[i] = gamma(i - 1 + alpha_1) * beta_1^alpha_1 / (gamma(i) * gamma(alpha_1) * (1 + beta_1)^(i - 1 + alpha_1))
}
p_moment[m] = 1 - sum(p_moment)
p_moment
sum(p_moment)

## Test
df_2_moment = Pearson_chisquare_test(nn = nn, p = p_moment, r = 2); df_2_moment

## 
## When alpha and beta are unknown, and they are estimated by their MLEs.
## 

## Compute theoretical probabilities
## MLE
## The MLE is very sensitive to the initial guess. 
## The moment estimator is usually a good initial guess.
res_Newtons = Newtons(fun = moment_fun, p = alpha_1_beta_1, x = x)
alpha_2_beta_2 = res_Newtons$root
alpha_2 = alpha_2_beta_2[1]; alpha_2
beta_2 = alpha_2_beta_2[2]; beta_2
p_MLE = rep(0, m)
for (i in 1:(m - 1)){
	p_MLE[i] = gamma(i - 1 + alpha_2) * beta_2^alpha_2 / (gamma(i) * gamma(alpha_2) * (1 + beta_2)^(i - 1 + alpha_2))
}
p_MLE[m] = 1 - sum(p_MLE)
p_MLE
sum(p_MLE)

## Test
df_2_MLE = Pearson_chisquare_test(nn = nn, p = p_MLE, r = 2); df_2_MLE


## 
## H0: X ~ Poisson(theta)
## 
## When theta is unknown, and it is estimated by its moment estimator or MLE.
## 

## Compute theoretical probabilities
## Moment estimator, MLE
theta = theta_1 = theta_2 = mean(x); theta
p = rep(0, m)
for (i in 1:(m - 1)){
	p[i] = theta^(i - 1) * exp(-theta) / gamma(i)
}
p[m] = 1 - sum(p)
p
sum(p)
n * p
nn
(nn - n * p)^2 / (n * p)

## Test
df_1 = Pearson_chisquare_test(nn = nn, p = p, r = 1); df_1

